-- FS25 Invoices - Main Script
-- Author: Bowur [PRIVATE]

Invoices = {}
local Invoices_mt = Class(Invoices)

function Invoices.new(isServer, isClient)
    local self = {}
    setmetatable(self, Invoices_mt)
    self.isServer = isServer
    self.isClient = isClient
    self.invoices = {}
    self.nextId = 1
    return self
end

function Invoices:load()
    -- Hier könnte später das Laden aus einer XML-Datei erfolgen
    print("Invoices: System geladen.")
end

function Invoices:save()
    -- Hier könnte später das Speichern in eine XML-Datei erfolgen
end

-- Erstellt eine neue Rechnung
function Invoices:addInvoice(senderFarmId, receiverFarmId, amount, dueDays, text)
    local inv = {
        id = self.nextId,
        senderFarmId = senderFarmId,
        receiverFarmId = receiverFarmId,
        amount = amount,
        dueDay = g_currentMission.environment.day + dueDays,
        text = text or "",
        state = 0, -- 0 = Offen, 1 = Bezahlt
        stateText = "OFFEN"
    }
    table.insert(self.invoices, inv)
    self.nextId = self.nextId + 1
    
    if self.isServer then
        -- Synchronisation an alle Clients senden
        -- (Hier würde normalerweise ein Netzwerk-Event aufgerufen)
    end
    return inv
end

-- Gibt alle Rechnungen sortiert zurück
function Invoices:getAllSorted()
    local sorted = {}
    -- Erst die offenen Rechnungen
    for _, inv in ipairs(self.invoices) do
        if inv.state == 0 then table.insert(sorted, inv) end
    end
    -- Dann die bezahlten Rechnungen
    for _, inv in ipairs(self.invoices) do
        if inv.state == 1 then table.insert(sorted, inv) end
    end
    return sorted
end

-- Markiert eine Rechnung als bezahlt
function Invoices:payInvoice(id)
    for _, inv in ipairs(self.invoices) do
        if inv.id == id then
            inv.state = 1
            inv.stateText = "BEZAHLT"
            return true
        end
    end
    return false
end

-- Löscht/Storniert eine Rechnung
function Invoices:cancelInvoice(id)
    for i, inv in ipairs(self.invoices) do
        if inv.id == id then
            table.remove(self.invoices, i)
            return true
        end
    end
    return false
end

-- Initialisierung des globalen Objekts
function initInvoices()
    if g_invoices == nil then
        g_invoices = Invoices.new(g_server ~= nil, g_client ~= nil)
        g_invoices:load()
    end
end

initInvoices()

----------------------------------------------------------------
-- FS25 Invoices – InGame-Menü-Integration (HDInvoicesMenu)
-- Dieser Block wurde automatisch hinzugefügt.
----------------------------------------------------------------

HDInvoicesMenu = HDInvoicesMenu or {}

HDInvoicesMenu.modDir = g_currentModDirectory or ""

function HDInvoicesMenu:getModDir()
    if self.modDir ~= nil and self.modDir ~= "" then
        return self.modDir
    end

    if g_modManager ~= nil and g_currentModName ~= nil then
        local modItem = g_modManager:getModByName(g_currentModName)
        if modItem ~= nil then
            if modItem.modFile ~= nil then
                local path = modItem.modFile
                self.modDir = path:sub(1, #path - string.len("modDesc.xml"))
                return self.modDir
            end
            if modItem.modDir ~= nil then
                self.modDir = modItem.modDir
                return self.modDir
            end
        end
    end

    self.modDir = ""
    return self.modDir
end

function HDInvoicesMenu:injectIntoMenu(inGameMenu)
    if inGameMenu == nil or g_gui == nil then
        return
    end

    if self.pageController ~= nil then
        return
    end

    if InGameMenuInvoices == nil then
        print("FS25_Invoices: InGameMenuInvoices-Klasse nicht geladen.")
        return
    end

    local modDir = self:getModDir()

    local controller = InGameMenuInvoices.new(g_i18n, g_messageCenter)

    g_gui:loadGui(
        Utils.getFilename("gui/InGameMenuInvoices.xml", modDir),
        "InGameMenuInvoices",
        controller,
        true
    )

    local iconFile = Utils.getFilename("images/menuIcon.dds", modDir)
    local iconUVs  = {0, 0, 64, 64}

    if iconFile == nil then
        iconFile = ""
    end

    inGameMenu:addPage(controller, nil, iconFile, iconUVs)

    self.pageController = controller

    print("FS25_Invoices: InGame-Menü-Seite 'Rechnungen' registriert.")
end

local function HDInvoices_onGuiSetupFinished(inGameMenu)
    HDInvoicesMenu:injectIntoMenu(inGameMenu)
end

if InGameMenu ~= nil and Utils ~= nil and Utils.appendedFunction ~= nil then
    InGameMenu.onGuiSetupFinished =
        Utils.appendedFunction(InGameMenu.onGuiSetupFinished, HDInvoices_onGuiSetupFinished)
else
    print("FS25_Invoices: Konnte InGameMenu.onGuiSetupFinished nicht hooken (InGameMenu/Utils nil).")
end
