CancelInvoiceEvent = {}
local CancelInvoiceEvent_mt = Class(CancelInvoiceEvent, Event)
InitEventClass(CancelInvoiceEvent, "CancelInvoiceEvent")

function CancelInvoiceEvent.emptyNew() return Event.new(CancelInvoiceEvent_mt) end

function CancelInvoiceEvent.new(invoiceId)
    local self = CancelInvoiceEvent.emptyNew()
    self.invoiceId = invoiceId
    return self
end

function CancelInvoiceEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, self.invoiceId)
end

function CancelInvoiceEvent:readStream(streamId, connection)
    self.invoiceId = streamReadInt32(streamId)
    self:run(connection)
end

function CancelInvoiceEvent:run(connection)
    if g_server ~= nil then
        -- permissions: only admins / manage rights
        local allowed = true
        if g_currentMission ~= nil and g_currentMission.getHasPlayerPermission ~= nil then
            allowed = g_currentMission:getHasPlayerPermission(Farm.PERMISSION.MANAGE_RIGHTS, connection)
        end
        if allowed and g_invoices:removeById(self.invoiceId) then
            g_server:broadcastEvent(CancelInvoiceEvent.new(self.invoiceId), false)
        end
    else
        g_invoices:removeById(self.invoiceId)
    end
end

function CancelInvoiceEvent.send(invoiceId)
    if g_client ~= nil then
        g_client:getServerConnection():sendEvent(CancelInvoiceEvent.new(invoiceId))
    end
end
