CreateInvoiceEvent = {}
local CreateInvoiceEvent_mt = Class(CreateInvoiceEvent, Event)
InitEventClass(CreateInvoiceEvent, "CreateInvoiceEvent")

function CreateInvoiceEvent.emptyNew()
    return Event.new(CreateInvoiceEvent_mt)
end

function CreateInvoiceEvent.new(senderFarmId, receiverFarmId, amount, text, dueDays)
    local self = CreateInvoiceEvent.emptyNew()
    self.senderFarmId = senderFarmId
    self.receiverFarmId = receiverFarmId
    self.amount = amount
    self.text = text or ""
    self.dueDays = dueDays or 3
    return self
end

function CreateInvoiceEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, self.senderFarmId)
    streamWriteInt32(streamId, self.receiverFarmId)
    streamWriteFloat32(streamId, self.amount)
    streamWriteString(streamId, self.text)
    streamWriteInt16(streamId, self.dueDays)
end

function CreateInvoiceEvent:readStream(streamId, connection)
    self.senderFarmId = streamReadInt32(streamId)
    self.receiverFarmId = streamReadInt32(streamId)
    self.amount = streamReadFloat32(streamId)
    self.text = streamReadString(streamId)
    self.dueDays = streamReadInt16(streamId)
    self:run(connection)
end

function CreateInvoiceEvent:run(connection)
    if g_server ~= nil then
        -- server creates and broadcasts the created invoice (incl. id/due/state)
        local inv = g_invoices:create(self.senderFarmId, self.receiverFarmId, self.amount, self.text, self.dueDays)
        g_server:broadcastEvent(CreateInvoiceEvent.new(inv.senderFarmId, inv.receiverFarmId, inv.amount, inv.text, self.dueDays), false)
    else
        -- client receives broadcast and creates locally too
        g_invoices:create(self.senderFarmId, self.receiverFarmId, self.amount, self.text, self.dueDays)
    end
end

function CreateInvoiceEvent.send(senderFarmId, receiverFarmId, amount, text, dueDays)
    if g_client ~= nil then
        g_client:getServerConnection():sendEvent(CreateInvoiceEvent.new(senderFarmId, receiverFarmId, amount, text, dueDays))
    end
end
