PayInvoiceEvent = {}
local PayInvoiceEvent_mt = Class(PayInvoiceEvent, Event)
InitEventClass(PayInvoiceEvent, "PayInvoiceEvent")

function PayInvoiceEvent.emptyNew() return Event.new(PayInvoiceEvent_mt) end

function PayInvoiceEvent.new(invoiceId)
    local self = PayInvoiceEvent.emptyNew()
    self.invoiceId = invoiceId
    return self
end

function PayInvoiceEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, self.invoiceId)
end

function PayInvoiceEvent:readStream(streamId, connection)
    self.invoiceId = streamReadInt32(streamId)
    self:run(connection)
end

function PayInvoiceEvent:run(connection)
    if g_server ~= nil then
        local ok = g_invoices:payServer(self.invoiceId)
        if ok then
            g_server:broadcastEvent(PayInvoiceEvent.new(self.invoiceId), false)
        end
    else
        local inv = g_invoices:getById(self.invoiceId)
        if inv ~= nil then inv.state = Invoices.STATE_PAID end
    end
end

function PayInvoiceEvent.send(invoiceId)
    if g_client ~= nil then
        g_client:getServerConnection():sendEvent(PayInvoiceEvent.new(invoiceId))
    end
end
